terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }
}

resource "aws_db_instance" "example" {
  identifier_prefix   = "terraform-up-and-running"
  allocated_storage   = 10
  instance_class      = "db.t2.micro"
  skip_final_snapshot = true

  # Włączenie tworzenia kopii zapasowej.
  backup_retention_period = var.backup_retention_period

  # Jeżeli ta zmienna jest zdefiniowana, ta baza danych będzie repliką.
  replicate_source_db = var.replicate_source_db

  # Te parametry będą zdefiniowane tylko w razie braku zmiennej replicate_source_db.
  engine   = var.replicate_source_db == null ? "mysql" : null
  db_name  = var.replicate_source_db == null ? var.db_name : null
  username = var.replicate_source_db == null ? var.db_username : null
  password = var.replicate_source_db == null ? var.db_password : null
}
